#include <arpa/inet.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <cerrno>
#include <cstring>
#include <iostream>
#include <string>

#include "./nixnet/SocketAddr.hpp"
#include "./nixnet/UdpSocket.hpp"
#include "./nixnet/errno.hpp"

using namespace std;

int main(int argc, char* argv[]) {
  if (argc != 4) {
    std::cerr << "usage: " << argv[0] << " dest_v6_addr port message"
              << std::endl;
    exit(EXIT_FAILURE);
  }

  nixnet::SocketAddr addr =
      nixnet::SocketAddr::v6_from_str(argv[1], argv[2])
          .expect("Invalid port or IPv6 address passed in");

  auto sock = nixnet::UdpSocket::unspecified_local_addr(AF_INET6).expect(
      "Couldn't create IPv6 send only socket");

  string_view msg = argv[3];

  // send a message
  auto sendto_res = sock.sendto(std::as_bytes(span(msg)), addr);

  // for debugging: print the:
  // - size of the message
  // - the message itself
  // - an error message if the send failled
  cout << msg.size() << endl;
  cout << msg << endl;

  if (!sendto_res) {
    cerr << nixnet::str_error(sendto_res.error()) << endl;
    cerr << "ERROR TO SEND THE FULL MESSAGE" << endl;
    return EXIT_FAILURE;
  }

  return EXIT_SUCCESS;
}
