#include <arpa/inet.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <array>
#include <cerrno>
#include <cstring>
#include <iostream>
#include <string>

#include "./nixnet/SocketAddr.hpp"
#include "./nixnet/UdpSocket.hpp"
#include "./nixnet/errno.hpp"

using namespace std;

int main(int argc, char* argv[]) {
  if (argc != 2) {
    cerr << "Usage: " << argv[0] << " port" << endl;
    return EXIT_FAILURE;
  }

  nixnet::SocketAddr addr =
      nixnet::SocketAddr::v6_from_str(nixnet::V6_INADDRANY, argv[1])
          .expect("Invalid port passed in");

  std::cout << "Creating socket with address: " << addr << std::endl;

  // bind a socket to local address
  auto sock = nixnet::UdpSocket::bind(addr).expect(
      "Couldn't create socket on :: w/ suplied port");

  // loop infinitely printing whatever
  // message we get and who sent it.
  while (true) {
    array<char, 1024> buf{};

    auto [size, sender] =
        sock.recvfrom(std::as_writable_bytes(span(buf)))
            .expect("Error receiving bytes from properly setup socket");

    string_view msg(buf.data(), size);

    std::cout << "Sender: " << sender << std::endl;
    std::cout << "message: " << msg << std::endl;
  }
}
