#include <stdlib.h>
#include <array>
#include <iostream>
#include <span>
#include <string_view>

#include "./nixnet/SocketAddr.hpp"
#include "./nixnet/TcpStream.hpp"
#include "./nixnet/errno.hpp"

// Connects to a server via TCP
// sends a message, waits for a response and prints the response.
int main(int argc, char** argv) {
  if (argc != 4) {
    std::cerr << "usage: " << argv[0] << " host_v6_addr port msg" << std::endl;
    exit(EXIT_FAILURE);
  }

  nixnet::SocketAddr addr =
      nixnet::SocketAddr::v6_from_str(argv[1], argv[2])
          .expect("Invalid port or IPv6 address passed in");

  std::cout << "Connecting to: " << addr << "...\n";

  auto sock = nixnet::TcpStream::connect(addr).expect(
      "Couldn't connect to specified address");

  // send msg to host
  std::string_view msg = argv[3];

  sock.send(std::as_bytes(std::span(msg)))
      .expect("ERROR when sending message to host");

  // receive a response
  std::array<char, 1024> buf{};
  size_t resp_len = sock.recv(std::as_writable_bytes(std::span(buf)))
                        .expect("ERROR when reading response from host");

  std::string_view resp(buf.data(), resp_len);
  std::cout << resp << std::endl;

  return EXIT_SUCCESS;
}
