#include <stdlib.h>
#include <iostream>

#include "./nixnet/SocketAddr.hpp"
#include "./nixnet/TcpListener.hpp"
#include "./nixnet/TcpStream.hpp"
#include "./nixnet/errno.hpp"

int main(int argc, char** argv) {
  if (argc != 2) {
    std::cerr << "Usage: " << argv[0] << " port" << std::endl;
    return EXIT_FAILURE;
  }

  nixnet::SocketAddr addr =
      nixnet::SocketAddr::v6_from_str(nixnet::V6_INADDRANY, argv[1])
          .expect("Invalid port passed in");
  std::cout << "trying to listen on address: " << addr << " ...\n";

  nixnet::TcpListener listener = nixnet::TcpListener::bind(addr).expect(
      "Couldn't create a listening socket on :: w/ supplied port");

  // Loop forever, accepting a connection from a client and doing
  // an echo trick to it.
  while (true) {
    auto [client, client_addr] =
        listener.accept().expect("Error accepting new client");

    std::cout << "Accepted client: " << client_addr << std::endl;

    std::array<char, 1024> buf{};

    // keep reading from the client, sending back whatever we read, until the
    // client closes their connection and thus 0 is returned by recv
    size_t msg_len = client.recv(std::as_writable_bytes(std::span(buf)))
                         .expect("ERROR reading msg from client");

    while (msg_len != 0) {
      std::cout << "got: \"" << std::string_view(buf.data(), msg_len) << "\"\n";
      size_t sent_len =
          client.send(std::as_bytes(std::span(buf.data(), msg_len)))
              .expect("Error writing response to client");
      if (sent_len != msg_len) {
        std::cerr << "ERROR: didn't send the full message for some reason?\n";
        break;
      }

      msg_len = client.recv(std::as_writable_bytes(std::span(buf)))
                    .expect("ERROR reading msg from client");
    }
  }

  return EXIT_SUCCESS;
}
