from django.urls import path
from . import views

app_name = 'polls'
urlpatterns = [
    # if we use view functions:
    # path("", views.index, name="homepage"),
    # path("<int:question_id>", views.question_detail, name="question_detail"),
    # path("<int:question_id>/results", views.question_results, name="question_results"),
    path("<int:question_id>/vote", views.vote, name="vote"),

    # if we use generic views:
    path("", views.IndexView.as_view(), name="homepage"),
    path("<int:pk>", views.DetailView.as_view(), name="question_detail"),
    path("<int:pk>/results", views.ResultsView.as_view(), name="question_results"),

    # User auth
    path("signup", views.signup, name="signup"),
    path("login", views.login_view, name="login"),
    path("logout", views.logout_view, name="logout"),
]